#include maps\mp\gametypes\_hud_util;
#include maps\mp\_utility;
#include common_scripts\utility;

init(){
	setDvarIfUninitialized("matchGameType", "gf");
	setDvarIfUninitialized("enableBotScript", 1); 
	setDvarIfUninitialized("botQuota", 2);
	setDvarIfUninitialized("botAttack", 1);
	setDvarIfUninitialized("bot_difficultyDefault", 3);
	setDvarIfUninitialized("botMove", 1);

	if(getdvar("matchGameType") == "gf")
		user_scripts\mp_patches\patches\gf_patch::init();
	else if(getdvar("matchGameType") == "gfs")
		user_scripts\mp_patches\patches\gfs_patch::init();
	else if(getdvar("matchGameType") == "oitc")
		user_scripts\mp_patches\patches\oitc_patch::init();
	else if(getdvar("matchGameType") == "hz")
		user_scripts\mp_patches\patches\hz_patch::init();
	else if(getdvar("matchGameType") == "koth")
		user_scripts\mp_patches\patches\koth_patch::init();
	else if(getdvar("matchGameType") == "mef")
		user_scripts\mp_patches\patches\mef_patch::init();
	else if(getdvar("matchGameType") == "quick")
		user_scripts\mp_patches\patches\quick_patch::init();
	else if(getdvar("matchGameType") == "db")
		user_scripts\mp_patches\patches\db_patch::init();
	else if(getdvar("matchGameType") == "forge")
		user_scripts\mp_patches\patches\forge_patch::init();
	else
		user_scripts\mp_patches\patches\default_patch::init();

	level thread monitorGameTypes();
	level thread handle_bot_count();
	level thread handle_bot_functions();
	level thread onplayerconnect();
}

monitorGameTypes()
{
	self endon ("disconnect");
	while (1)
	{
		// Only run when the gametype changes
		if (getDvar("matchGameType") != getDvar("resettype"))
		{
			setDvar("resettype", getDvar("matchGameType"));
			iPrintLn("^4Gametype changed to ^1" + getGametypeName(getDvar("matchGameType")));

			loadDefaultDvars();

			gt = getDvar("matchGameType");

			setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:"+getGametypeName(getdvar("matchGameType")));

			if (gt == "gf")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:Gunfight");
				// setDvar("g_log", "logs/gf.log");
				// setDvar("scr_player_healthregentime", 1000);

				setDvar("g_gametype", "sd");
				setDvar("botQuota", 2);

				setDvar("mv_maps", "mp_mogadishu mp_seatown mp_paris mp_dome mp_creek mp_killhouse mp_farm_spring mp_crash_snow mp_bog_summer mp_convoy mp_backlot mp_bog mp_crossfire mp_farm mp_overgrown mp_shipment mp_vacant mp_countdown mp_bloc mp_pipeline mp_cargoship mp_rundown mp_afghan mp_derail mp_estate mp_favela mp_highrise mp_invasion mp_checkpoint mp_quarry mp_rust mp_boneyard mp_nightshift mp_subbase mp_terminal mp_underpass mp_brecourt mp_complex mp_compact mp_storm");
				setDvar("mv_gametypes", "random;sd.cfg assault;sd.cfg sniper;sd.cfg pistol;sd.cfg lmg;sd.cfg smg;sd.cfg shotgun;sd.cfg bolt;sd.cfg");

				// Campaign DLC Maps:
				// setDvar("mv_maps", "mp_paris mp_dome mp_mountain mp_creek dcburning cliffhanger mp_killhouse mp_strike mp_farm_spring mp_crash_snow mp_bog_summer mp_convoy mp_backlot mp_bog mp_crossfire mp_farm mp_overgrown mp_shipment mp_vacant mp_countdown mp_bloc mp_pipeline mp_cargoship mp_rundown mp_afghan mp_derail mp_estate mp_favela mp_highrise mp_invasion mp_checkpoint mp_quarry mp_rust mp_boneyard mp_nightshift mp_subbase mp_terminal mp_underpass mp_brecourt mp_complex mp_compact mp_storm");
			}
			else if (gt == "gfs")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:Gunfight: Search and Destroy");
				// setDvar("g_log", "logs/gf.log");

				setDvar("g_gametype", "sd");
				setDvar("botQuota", 2);

				//setDvar("mv_maps", "mp_mogadishu mp_seatown mp_paris mp_dome mp_creek mp_killhouse mp_farm_spring mp_crash_snow mp_bog_summer mp_convoy mp_backlot mp_bog mp_crossfire mp_farm mp_overgrown mp_shipment mp_vacant mp_countdown mp_bloc mp_pipeline mp_cargoship mp_rundown mp_afghan mp_derail mp_estate mp_favela mp_highrise mp_invasion mp_checkpoint mp_quarry mp_rust mp_boneyard mp_nightshift mp_subbase mp_terminal mp_underpass mp_brecourt mp_complex mp_compact mp_storm");
				setDvar("mv_gametypes", "random;sd.cfg assault;sd.cfg sniper;sd.cfg pistol;sd.cfg lmg;sd.cfg smg;sd.cfg shotgun;sd.cfg bolt;sd.cfg");
			}
			else if (gt == "oitc")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:One In The Chamber ^3[Bolty/Pistol]");
				// setDvar("g_log", "logs/oitc.log");

				setDvar("scr_dm_scorelimit", 50);
				setDvar("g_gametype", "dm");
				setDvar("scr_game_hardpoints", 0);
				setDvar("scr_dm_timelimit", 20);

				setDvar("botQuota", 10);
				setDvar("mv_gametypes", "dm;dm.cfg");
			}
			else if (gt == "ph")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:Prop Hunt");
				// setDvar("g_log", "logs/ph.log");

				setDvar("g_gametype", "war");
				setDvar("botQuota", 4);
				setDvar("mv_gametypes", "dm;dm.cfg");
			}
			else if (gt == "hz")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:Hawkins ^:Infected ^:Zombies");
				// setDvar("g_log", "logs/hawkins.log");

				setDvar("g_gametype", "war");
				setDvar("scr_game_hardpoints", 0);

				setDvar("botQuota", 18);
				setDvar("mv_gametypes", "war;war.cfg");
			}
			else if (gt == "koth")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:King Of The Hill");
				// setDvar("g_log", "logs/koth.log");

				setDvar("g_gametype", "dom");
				setDvar("scr_game_hardpoints", 0);
				setDvar("scr_sab_playerrespawndelay", 0);

				setDvar("botQuota", 18);
				setDvar("mv_gametypes", "dom;dom.cfg");
			}
			else if (gt == "quick")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:Quick Scoping");
				// setDvar("g_log", "logs/quick.log");

				setDvar("g_gametype", "dm");
				setDvar("scr_game_hardpoints", 0);
				setDvar("scr_dm_scorelimit", 50);

				setDvar("botQuota", 10);
				setDvar("mv_gametypes", "dm;dm.cfg");
			}
			else if (gt == "forge")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:Forge");
				// setDvar("g_log", "logs/forge.log");

				setDvar("g_gametype", "dm");
				setDvar("scr_game_hardpoints", 0);

				setDvar("scr_dm_scorelimit", 0);
				setDvar("scr_dm_timelimit", 0);

				setDvar("botQuota", 0);
				setDvar("mv_gametypes", "dm;dm.cfg");
			}
			else if (gt == "mef")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:Make Em Fall");
				// setDvar("g_log", "logs/mef.log");

				setDvar("g_gametype", "dm");
				setDvar("scr_player_healthregentime", 1000);
				setDvar("scr_game_hardpoints", 0);

				setDvar("scr_dm_timelimit", 0);
				setDvar("scr_dm_scorelimit", 0);
				setDvar("scr_player_maxhealth", 10000);

				setDvar("mv_gametypes", "dm;dm.cfg");
				setDvar("botQuota", 2);

				setDvar("mv_maps", "mp_boneyard mp_checkpoint mp_derail mp_highrise mp_nightshift mp_quarry mp_rust mp_terminal");

				randomMap = strTok(getDvar("mv_maps"), " ");
				wait 3;
				executecommand("map " + randomMap[randomInt(randomMap.size)]);
				return;
			}
			else if (gt == "db")
			{
				//setDvar("sv_hostname", "^5[US] ^3Apes Only ^7- ^:Dodge Ball");
				// setDvar("g_log", "logs/db.log");

				setDvar("g_gametype", "sd");
				setDvar("scr_game_hardpoints", 0);

				setDvar("mv_gametypes", "sd;sd.cfg");
				setDvar("mv_maps", "mp_favela");
				setDvar("scr_player_maxhealth", "10");

				setDvar("botQuota", 2);

				wait 3;
				executecommand("map mp_favela");
				return;
			}

			wait 3;
			level notify("restarting");
			executecommand("map_restart");
		}
		wait 1;
	}
}


loadDefaultDvars(){

	setDvar( "scr_sd_scorelimit", 1 );
	setDvar( "scr_sd_timelimit", 2.5 );
	setDvar( "scr_sd_roundlimit", 0 );
	setDvar( "scr_sd_winlimit", 4 );
	setDvar( "scr_dom_roundlimit", 1 );
	setDvar( "scr_dom_scorelimit", 200 );
	setDvar( "scr_dom_timelimit", 0 );
	setDvar( "scr_dom_winlimit", 1 );
	setDvar( "scr_horde_roundlimit", 1 );
	setDvar( "scr_horde_winlimit", 1 );
	setDvar( "scr_horde_scorelimit", 0 );
	setDvar( "scr_horde_timelimit", 0 );
	setDvar( "scr_sr_winlimit", 6 );
	setDvar( "scr_sr_roundlimit", 0 );
	setDvar( "scr_sr_scorelimit", 1 );
	setDvar( "scr_sr_timelimit", 2.5 );
	setDvar( "scr_conf_roundlimit", 1 );
	setDvar( "scr_conf_scorelimit", 65 );
	setDvar( "scr_conf_winlimit", 1 );
	setDvar( "scr_infect_roundlimit", 1 );
	setDvar( "scr_infect_winlimit", 1 );
	setDvar( "scr_infect_timelimit", 10 );
	setDvar( "scr_dm_roundlimit", 1 );
	setDvar( "scr_dm_timelimit", 10 );
	setDvar( "scr_dm_scorelimit", 25 );
	setDvar( "scr_dm_winlimit", 1 );
	setDvar( "scr_war_scorelimit", 75 );
	setDvar( "scr_war_winlimit", 1 );
	setDvar( "scr_war_roundlimit", 1 );
	
	//setDvar("sv_hostname", "^5[US] ^3Apes Only");
	setDvar("scr_player_healthregentime", 5);
	setdvar("scr_game_hardpoints", 1 );
	setdvar("scr_sd_numlives", 1 );
    setDvar("stopspeed", 200);
	setDvar("jump_slowdownEnable", 0);
    setDvar("scr_dm_timelimit", 10);
	setDvar("scr_player_maxhealth", 100);
	setDvar("scr_sab_playerrespawndelay", 7.5);
	setdvar("scr_dm_numlives", 0 );
	//setDvar("mv_gametypes", "war;war.cfg");
	SetDvar("mv_socialname", "Homosapien Apes");
	SetDvar("mv_sociallink", "^3www.homoapes.com^7");
	SetDvar("mv_sentence", "Created by TheUncleBobbyB");
	setDvar("mv_maps", "mp_killhouse mp_strike mp_farm_spring mp_crash_snow mp_bog_summer mp_convoy mp_backlot mp_bog mp_crossfire mp_farm mp_overgrown mp_shipment mp_vacant mp_carentan mp_countdown mp_bloc mp_pipeline mp_cargoship mp_rundown mp_afghan mp_derail mp_estate mp_favela mp_highrise mp_invasion mp_checkpoint mp_quarry mp_rust mp_boneyard mp_nightshift mp_subbase mp_terminal mp_underpass mp_brecourt mp_complex mp_compact mp_storm");
	
}

getGametypeName(var_0){
	var_1 = "";
	switch(var_0){
		case "gf":
			var_1 = "Gunfight";
		break;
		case "gfs":
			var_1 = "Gunfight: Search and Destroy";
		break;
		case "oitc":
			var_1 = "One In The Chamber";
		break;
		case "hz":
			var_1 = "Hawkins Zombies";
		break;
		case "koth":
			var_1 = "King Of The Hill";
		break;
		case "quick":
			var_1 = "Quick Scoping";
		break;
		case "db":
			var_1 = "Dodge Ball";
		break;
		case "mef":
			var_1 = "Make Em Fall";
		break;
		case "forge":
			var_1 = "Forge";
		break;
		case "dm":
			var_1 = "Free For Fall";
		break;
		case "war":
			var_1 = "Team Deathmatch";
		break;
		case "sd":
			var_1 = "Search & Destroy";
		break;
		case "ctf":
			var_1 = "Capture the Flag";
		break;
		case "sab":
			var_1 = "Sabotage";
		break;
		case "dom":
			var_1 = "Domination";
		break;
		case "gun":
			var_1 = "Gun Game";
		break;
		case "ph":
			var_1 = "Prop Hunt";
		break;
		default:
			var_1 = "Unknown Gamemode";
		break;
	}
	if(var_0 == "gf" || var_0 == "gfs"){
		return var_1 + " ^7(" + getGunfightWeaponType() + ")";
	}
	else{
		return var_1;
	}
}

getGunfightWeaponType(){
	var_0 = getDvar("forced_weapon");
	switch (tolower(var_0))
	{
	case "assault":
		return "Assault Rifles";
	case "sniper":
		return "Snipers";
	case "pistol":
		return "Pistols";
	case "lmg":
		return "LMGs";
	case "smg":
		return "SMGs";
	case "shotgun":
		return "Shotguns";
	case "random":
		return "Random Weapons";
	case "bolt":
		return "Bolt Actions";
	}
	return "invalid";
}

onplayerconnect()
{
    for (;;)
    {
        level waittill( "connected", player );
		player thread onplayerspawned();
		player thread fixDeathMatchPoints();
    }
}

onplayerspawned()
{
    level endon( "game_ended" );
    for (;;){
		self waittill( "spawned_player" );
		//self setClientDvar("safeArea_adjusted_vertical", 1);
		//self setClientDvar("safeArea_adjusted_horizontal", 1);
		//self setClientDvar("safeArea_vertical", 1);
		//self setClientDvar("safeArea_horizontal", 1);//HMW doesn't allow you to change other players safe area.
		self thread welcomePlayer();
		self thread monitor_slide();
		if(!isBot(self))
			level notify("player_spawned");
		//if(!self.votinggg){
		//	self.votinggg=true;
		//	scripts\mp\mapvote::start();
		//}
	}  
}

isPlayerSprinting()
{
    // Best signal if supported
    if ( isdefined( self.issprinting ) && self.issprinting )
        return true;

    // Some engines expose this
    if ( self isSprinting() )
        return true;

    // Fallback: sprint intent (forward + sprint key)
    move = self getnormalizedmovement();
    if ( move[0] > 0.8 && self sprintbuttonpressed() )
        return true;

    return false;
}

monitor_slide() {
    self endon( "death" );
    self endon( "game_ended" );
    self endon( "disconnect" );

	level.slide_time = 0.45;
	level.slide_multiplier = 1.47;
	level.slide_dampening = 0.050;


    for(;;) {
        self notifyOnPlayercommand( "start_slide", "+stance" );
		self notifyOnPlayercommand( "start_slide2", "+togglecrouch" );
		self waittill_any("start_slide", "start_slide2");
        if ( self IsOnGround() && isPlayerSprinting() ) {
            self setVelocity( self getvelocity() * level.slide_multiplier );
            slide_begin();
            wait level.slide_time;
			waitframe;
            slide_end();
        }
    }
    wait 1;
}

slide_begin( var_0, var_1, var_2 ) {
    self endon( "death" );
    self endon( "game_ended" );
    self endon( "disconnect" );

    slide_target = self;
    var_4 = isdefined( level.custom_linkto_slide );
    if ( !isdefined( var_0 ) ) {
        var_0 = slide_target getvelocity() + ( 0, 0, -10 );
    }
    if ( !isdefined( var_1 ) ) {
        var_1 = 10;
    }
    if ( !isdefined( var_2 ) ) {
        if ( isdefined( level.slide_dampening ) ) {
            var_2 = level.slide_dampening;
        }
        else {
            var_2 = 0.035;
        }
    }
    var_5 = spawn( "script_origin", slide_target.origin );
    var_5.angles = slide_target.angles;
    slide_target.slidemodel = var_5;
    var_5 moveslide( ( 0, 0, 15 ), 15, var_0 );
    if ( var_4 ) {
        slide_target playerlinktoblend( var_5, undefined, 1 );
    }
    else {
        slide_target playerlinkto( var_5 );
    }
    slide_target allowprone( false );
    slide_target allowstand( false );
    slide_target allowsprint( false );
	slide_target playlocalsound( "slide_start_plr_default" );
    slide_target thread slide_main( var_5, var_1, var_2 );
    //slide_target playloopsound( "slide_loop_plr_default" );
}

slide_main( var_0, var_1, var_2 )
{
    self endon( "death" );
    self endon( "game_ended" );
    self endon( "disconnect" );
    self endon( "stop_sliding" );

    slide_target = self;

    if ( !isdefined( var_0.slidevelocity ) )
        var_0.slidevelocity = slide_target getvelocity();

    // Run every frame instead of 0.05s (20Hz), which is a common cause of jitter.
    for (i=0;i<100000;i++)
    {
        move = slide_target getnormalizedmovement();
        fwd  = anglestoforward( slide_target.angles );
        rgt  = anglestoright( slide_target.angles );

        wish = ( move[1] * rgt[0] + move[0] * fwd[0],
                 move[1] * rgt[1] + move[0] * fwd[1],
                 0 );

        // Integrate input influence into slide velocity
        var_0.slidevelocity = var_0.slidevelocity + wish * var_1;

        // Apply dampening every frame (small)
        var_0.slidevelocity = var_0.slidevelocity * ( 1 - var_2 );

        // Keep a stable copy for slide_end to use
        slide_target.final_slide_vel = var_0.slidevelocity;

		if(i > 7){
			slide_target allowprone( true );
			slide_target allowstand( true );
			slide_target allowsprint( true );
		}

        waitframe; // ~60fps
    }
}


slide_end()
{
    self endon( "death" );
    self endon( "game_ended" );
    self endon( "disconnect" );

    slide_target = self;
		

    // stop the slide loop first so input no longer changes velocity
    slide_target notify( "stop_sliding" );

    if ( !isdefined( slide_target.slidemodel ) )
        return;

    // restore permissions AFTER we're basically done
    // (doing it while linked can cause resolve snaps)
    // we'll do it at the end.

    // Get the last known slide velocity
    vel = slide_target.slidemodel.slidevelocity;
    if ( isdefined( slide_target.final_slide_vel ) )
        vel = slide_target.final_slide_vel;

    // remove vertical
    vel = ( vel[0], vel[1], 0 );

    // If already slow, just finish instantly
    if ( length( vel ) < 35 )
    {
        slide_target.slidemodel.slidevelocity = (0,0,0);
        waitframe;
        slide_target unlink();
        slide_target.slidemodel delete();

        slide_target allowprone( true );
        slide_target allowstand( true );
        slide_target allowsprint( true );
        slide_target playlocalsound( "slide_ease_out_plr_default" );
        slide_target.final_slide_vel = undefined;
        return;
    }

        // --- Fade the MODEL velocity to zero over a short time ---
    duration = 0.07;
    steps    = int( duration / 0.016 );
    if ( steps < 4 ) steps = 4;
    if ( steps > 10 ) steps = 10;

    // How much control the player gets near the end.
    // 0.0 = none, 1.0 = full (too much)
    controlMax = 0.85; // try 0.45–0.70

    for ( i = 0; i < steps; i++ )
    {
        t  = ( i + 1.0 ) / steps;
        tt = t * t * ( 3 - 2 * t );   // smoothstep 0->1

        // base slide easing
        base = vel * ( 1 - tt );

        // --- add player control during the end of the slide ---
        move = slide_target getnormalizedmovement();
        fwd  = anglestoforward( slide_target.angles );
        rgt  = anglestoright( slide_target.angles );

        wish = ( move[1] * rgt[0] + move[0] * fwd[0],
                 move[1] * rgt[1] + move[0] * fwd[1],
                 0 );

        // ramp player control up as the slide ends
        control = controlMax * tt;

        // scale wish into a velocity nudge
        // 220 is a good starting speed; tune 160–300
        wishVel = wish * 220 * control;

        slide_target.slidemodel.slidevelocity = base + wishVel;

        waitframe;
    }

    // now truly stopped
    slide_target.slidemodel.slidevelocity = (0,0,0);
    waitframe;

    // detach when there's no motion to "correct"
    slide_target unlink();
    slide_target.slidemodel delete();

    slide_target allowprone( true );
    slide_target allowstand( true );
    slide_target allowsprint( true );

    slide_target playlocalsound( "slide_ease_out_plr_default" );
    slide_target.final_slide_vel = undefined;
}






fixDeathMatchPoints(){
	self endon("disconnect");
	if(getDvar("g_gametype") == "dm"){
		for(;;){
			if(self.score != self.extrascore0){
				self.extrascore0 = self.score;
			}
			wait 0.1;
		}
	}
}

handle_bot_functions()
{
    level endon( "game_ended" );
	//level waittill( "prematch_over" );
    for(;;)
    {
		foreach(player in level.players)
		{
			if( isBot( player ) )
			{
				if(getDvarInt("botAttack") != 1){
					player allowMelee(false);
					player allowFire(false);
				}
				else{
					player allowMelee(true);
					player allowFire(true);
				}
				if(getDvarInt("botMove") == 1){
					player botsetflag( "disable_movement", 0 );
				}
				else{
					player botsetflag( "disable_movement", 1 );
				}
			}
		}
		wait 1;
    }
}

handle_bot_count()
{
	level endon("game_ended");

	for (;;)
	{
		while (game["gamestarted"] != 1)
			wait 1;

		if (getDvarInt("enableBotScript") == 1)
		{
			bot_quota = getDvarInt("botQuota");
			wait 0.5;

			// Count humans vs bots
			humans = 0;
			bots   = 0;

			foreach (p in level.players)
			{
				if (isBot(p))
					bots++;
				else
					humans++;
			}

			// No real players = no bots
			if (humans == 0)
			{
				// Kick any bots that might already be present
				if (bots > 0)
				{
					foreach (p in level.players)
					{
						if (isBot(p))
							kick(p getEntityNumber());
					}
				}

				wait 1;
				continue;
			}

			// With at least 1 real player: keep total players at bot_quota
			desired_bots = bot_quota - humans;
			if (desired_bots < 0)
				desired_bots = 0;

			// Spawn missing bots
			if (bots < desired_bots)
			{
				fill_amount = desired_bots - bots;

				for (i = 0; i < fill_amount; i++)
				{
					executecommand("spawnbot 1");
					wait 0.05;
				}

				logPrint("^4Filling lobby with bots: " + fill_amount + " bots (humans=" + humans + ", quota=" + bot_quota + ")");
			}
			// Kick extras
			else if (bots > desired_bots)
			{
				remove_amount = bots - desired_bots;

				for (i = 0; i < remove_amount; i++)
				{
					foreach (p in level.players)
					{
						if (isBot(p))
						{
							kick(p getEntityNumber());
							wait 0.05;
							break;
						}
					}
				}
			}
		}
		else if (getDvarInt("enableBotScript") == -1)
		{
			// Hard disable: kick all bots
			foreach (p in level.players)
			{
				if (isBot(p))
					kick(p getEntityNumber());
			}
		}

		wait 1;
	}
}



welcomePlayer(){
    if(!self.welcomed){
        self.welcomed = true;
        self thread modCredit();
    }
}

modCredit(){
	self.credits = self createFontString("objective", 0.8);
	self.credits setPoint( "BOTTOM CENTER", "BOTTOM CENTER", 0, -2);
	self.credits.color = ((255/255),(255/255),(255/255));
	self.credits.alpha = 0.7;
    self.credits.glowColor = ((0/255),(0/255),(0/255));
    self.credits.glowAlpha = 0.7;
	self.credits setText(getGametypeName(getdvar("matchGameType"))+" | Created by TheUncleBobbyB | www.homoapes.com");
	self.credits thread destroyOn();
}

destroyOn(){
	level waittill_any("begin_overtime", "overtime_over", "game_ended", "showing_final_killcam", "game_cleanup");
	if ( isdefined( self ) )
		self destroy();
}